<?php
/*
	Stempora web framework
	copyright (c) 2002-2016 Stempora
		web:  www.stempora.com
		mail: support@stempora.com
*/

/**
* description
*
* @library	
* @author	
* @since	
*/
class CDashboard extends CPlugin{
	
	var $tplvars; 

	function __construct() {
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;


		if ($_GET["mod"] == "dashboard") {

			switch ($_GET["sub"]) {
				default:
					return $this->BuildDashboard();
				break;

				case "redirect":
					return $this->Redirect();
				break;
			}
		}
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function BuildDashboard() {
		global $base , $_TSM , $_CONF;
		$_GET["showempty"] = 1;

		$_TSM["PUB:MODULE_NAME"] = "My Dashboard";

		$modules = $this->db->QFetchRowArray("SELECT * FROM {$this->private->tables['core:user_modules']} WHERE mod_status=1 ORDER BY mod_order ASC");

		$core = $this->db->QFetchRowArray("SELECT * FROM {$this->private->tables['core:modules']} WHERE module_type=2 AND module_status=1 ORDER BY module_type_name");
	
		if ($_USER["user_level"]) {
			$perm = explode("," , $_USER["user_perm"]);
		}

		//remove modules without permission
		if (is_array($modules)) {
			foreach ($modules as $key => $val) {

				if (($_USER["user_level"] && !in_array($val["mod_id"] , $perm))  ) {
					unset($modules[$key]);
				}
			}			
		}

		if (is_array($core)) {
			foreach ($core as $key => $val) {
				if (is_object($this->module->plugins[$val["module_code"]])) {
					$widget = $this->module->plugins[$val["module_code"]]->DashboardWidgets($val["module_id"]);

					if (is_array($widget) && count($widget)) {
						foreach ($widget as $k => $v) {
							$_widgets[] = $v;
						}				
					}			

					$nr = $this->module->plugins[$val["module_code"]]->DashboardNumbers($val["module_id"]);

					if (is_array($nr) && count($nr)) {
						foreach ($nr as $k => $v) {
							$_nr[] = $v;
						}				
					}			
				}

			}
		}
		
		if (is_array($modules)) {
			foreach ($modules as $key => $val) {
				if (is_object($this->module->plugins[$val["mod_module_code"]])) {
					$widget = $this->module->plugins[$val["mod_module_code"]]->DashboardWidgets($val["mod_id"]);

					if (is_array($widget) && count($widget)) {
						foreach ($widget as $k => $v) {
							$_widgets[] = $v;
						}				
					}			

					$nr = $this->module->plugins[$val["mod_module_code"]]->DashboardNumbers($val["mod_id"]);

					if (is_array($nr) && count($nr)) {
						foreach ($nr as $k => $v) {
							$_nr[] = $v;
						}				
					}			

				}				
			}
		}

		//$_widgets[] = $this->DashboardWidgets();

		if (is_array($_widgets)) {
			foreach ($_widgets as $key => $val) {
			}			
		} else {

			//no widgets redirect to manage pages
			//show nothing because it might not have access to moduels
			//urlredirect("index.php?mod=modules&sub=user");
		}

		$template = new CTemplateDynamic($this->tpl_path . "main.htm");

		return $template->blockReplace(
			"Main" , 
			array(
				"widgets"	=> count($_widgets) ? $base->html->table(
					$template , 
					"" , 
					$_widgets
				) : "",

				"nr" => count($_nr) ? $base->html->table(
					$template , 
					"Nr" , 
					$_nr
				) : "",

			)
		);	

	}
	


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function TopNotifications(&$template , $ajax = false) {
		global $base , $_USER;

		if (!$_USER["user_id"]) {
			return "";
		}
		

		$this->tpl_module = $this->module->plugins["modules"]->LoadDefaultModule("dashboard");

		if (!is_array($this->tpl_module)) {
			return "";
		}
		

		$modules = $this->db->QFetchRowArray("SELECT * FROM {$this->private->tables['core:user_modules']} WHERE mod_status=1 ORDER BY mod_order ASC");

		$core = $this->db->QFetchRowArray("SELECT * FROM {$this->private->tables['core:modules']} WHERE module_type=2 AND module_status=1 ORDER BY module_type_name");
	
		if ($_USER["user_level"]) {
			$perm = explode("," , $_USER["user_perm"]);
		}

		//remove modules without permission
		if (is_array($modules)) {
			foreach ($modules as $key => $val) {

				if (($_USER["user_level"] && !in_array($val["mod_id"] , $perm))  ) {
					unset($modules[$key]);
				}
			}			
		}

		if (is_array($core)) {
			foreach ($core as $key => $val) {
				if (is_object($this->module->plugins[$val["module_code"]])) {
					$nr = $this->module->plugins[$val["module_code"]]->DashboardNumbers($val["module_id"]);

					if (is_array($nr) && count($nr)) {
						foreach ($nr as $k => $v) {
							$_nr[] = $v;
						}				
					}			
				}

			}
		}
		
		if (is_array($modules)) {
			foreach ($modules as $key => $val) {
				if (is_object($this->module->plugins[$val["mod_module_code"]])) {
					$nr = $this->module->plugins[$val["mod_module_code"]]->DashboardNumbers($val["mod_id"]);

					if (is_array($nr) && count($nr)) {
						foreach ($nr as $k => $v) {
							$_nr[] = $v;
						}				
					}			

				}				
			}
		}

		//$_widgets[] = $this->DashboardWidgets();

		if (is_array($_nr)) {
			$cnt = 0;
			foreach ($_nr as $key => &$val) {
				if ($val["count"]) {
					$cnt+= $val["count"];
					$val["count"] = $template->blockReplace("Count" , $val);
				} else {
					$val["count"] = "";
				}
				
			}			
		} else {

		}

		if ($cnt ) {

			$fav = $template->blockreplace(
				"FavIcon",
				array(
					"count"	=> $cnt > 10 ? "10+" : $cnt
				)
			);
		}
		

		return $template->blockReplace(
			$ajax ? "Ajax" : "Main", 
			array(
				"items" => $base->html->table(
					$template , 
					"" , 
					$_nr
				),

				"fav"	=> $fav
			)
		);	

	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function UpdateModuleAction($module) {
		global $_USER , $_ADMIN , $_SESS;

		if (((constant("STP_ENABLE_DEMO") == 1) && ($_ADMIN ==true)) || ($_SESS["minibase"]["raw"]["acl"] == "viewonly")){
			return "";
		}		


		$info = $this->db->QFetchArray("
			SELECT * 
			FROM 
				{$this->tables['core:dashboard_admin_notify']}
			WHERE
				module_id=%d AND 
				user_id=%d
			",array(
					$module , 
					$_USER["user_id"]
			)
		);

		if (is_array($info)) {
			$this->db->QueryUpdate(
				$this->tables['core:dashboard_admin_notify'],
				array(
					"notify_date"	=> time()
				),
				"notify_id={$info[notify_id]}"
			);
		} else {
			$this->db->QueryInsert(
				$this->tables['core:dashboard_admin_notify'],
				array(
					"user_id"		=> $_USER["user_id"],
					"module_id"		=> $module,
					"notify_date"	=> time()
				)
			);
		}		
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetAccessDate($module) {
		global $_USER;

		$info = $this->db->QFetchArray("
			SELECT * 
			FROM 
				{$this->tables['core:dashboard_admin_notify']}
			WHERE
				module_id=%d AND 
				user_id=%d
			",array(
					$module , 
					$_USER["user_id"]
			)
		);

		if (!is_array($info)) {
			return 0;
		} else {
			return $info["notify_date"];
		}		
	}
	
	
	
}

?>
